## -*- mode: R -*-
##
## Copyright (C) 2025 Takeshi Abe <tabe@fixedpoint.jp>
##
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <https://www.gnu.org/licenses/>.

#'
#' Morphological measurement taken from 113 maritime earwigs (Anisolabis maritima); 68 males and 45 females.
#'
#' @format A data frame with twelve variables:
#' \describe{
#' \item{\code{id}}{ID (integer; starting from 1, ending at 115; 11 and 12 are missing)}
#' \item{\code{sex}}{Sex (factor; male or female)}
#' \item{\code{head_width}}{Head width (mm)}
#' \item{\code{head_length}}{Head length (mm)}
#' \item{\code{thorax_width}}{Thorax width (mm)}
#' \item{\code{thorax_length}}{Thorax length (mm)}
#' \item{\code{abdomen_width}}{Abdomen width (mm)}
#' \item{\code{abdomen_length}}{Abdomen length (mm)}
#' \item{\code{right_forcep_length}}{Right forcep length (mm)}
#' \item{\code{left_forcep_length}}{Left forcep length (mm)}
#' \item{\code{right_forcep_width}}{Right forcep width (mm)}
#' \item{\code{left_forcep_width}}{Left forcep width (mm)}
#' }
#'
#' For further details, see Tomoki Matsuzawa, Junji Konuma, Positive allometry in the forceps of the female earwig Anisolabis maritima (Dermaptera: Anisolabididae), Biological Journal of the Linnean Society, Volume 145, Issue 2, June 2025, blaf031, \doi{10.1093/biolinnean/blaf031}.
#'
"earwigs"

