% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{almanac-defaults}
\alias{almanac-defaults}
\alias{almanac_since}
\alias{almanac_until}
\title{Default values in almanac}
\usage{
almanac_since()

almanac_until()
}
\description{
\itemize{
\item \code{almanac_since()} represents the default \code{since} date used in almanac. It
defaults to \code{1900-01-01}, a Monday.
\item \code{almanac_until()} represents the default \code{until} date used in almanac. It
defaults to \code{2100-01-01}, a Friday.
}

The choice of \code{since} and \code{until} are somewhat arbitrary, but should generate
a useful event set range for most rschedules. If you need to adjust the
defaults, then you should supply the \code{since} and \code{until} arguments directly
to the rrule generators, like \code{\link[=yearly]{yearly()}} and \code{\link[=weekly]{weekly()}}.

The \code{since} default is particularly important for weekly recurrence rules,
where the \code{since} date represents the anchor point to begin counting from.
See \code{\link[=recur_on_day_of_week]{recur_on_day_of_week()}} for examples of how to adjust this.
}
\examples{
almanac_since()
almanac_until()
}
