% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_FRS.R
\name{a_FRS}
\alias{a_FRS}
\title{Alternative Fistula Risk Score (a-FRS)}
\usage{
a_FRS(my_data)
}
\arguments{
\item{my_data}{A data frame containing the columns Texture ("soft = 1" or "hard = 0"), PD_size Numeric (Pancreatic duct diameter in millimeters), and BMI Numeric (Body mass index in kg/m²).}
}
\value{
A data frame with the calculated alternative Fistula Risk Score (FRS) and risk classification of CR-POPF following pancreatoduodenectomy. Returns NA for cases with missing values.
}
\description{
Calculates the alternative Fistula Risk Score (FRS) based on gland Texture, pancreatic duct diameter, and BMI.
Postoperative pancreatic fistula (POPF) is a significant complication following pancreatoduodenectomy (PD).
The Fistula Risk Score (FRS), initially proposed by Callery et al. in 2013, includes parameters such as gland texture, pancreatic duct diameter, and pathology.
Recent validations suggest reconsidering the inclusion of intraoperative blood loss in the FRS due to its minimal impact on POPF outcomes, exclusion from national audits like US-NSQIP and DPCA, and its dependence on surgical technique rather than patient factors.
Therefore, a blood loss-independent fistula risk score is essential for accurate risk assessment in future studies. Visit \url{https://www.evidencio.com/models/show/621} for more information.
}
\details{
This function calculates the risk of Postoperative Pancreatic Fistula (POPF) following pancreatoduodenectomy using the specified parameters:
\itemize{
\item \code{Texture : } Nature of pancreatic texture (Firm or Hard = 0 or Soft = 1)
\item \code{BMI :} Body mass index in Kg/m²
\item \code{PD_size :} Size of the pancreatic duct in mm
}
}
\examples{
my_data <- data.frame(
  ID = 1:4,
  Texture = c(0, 1, 0, 0),
  BMI = c(22, 25, 30, 20),
  PD_size = c(5, 10, 1, 2)
)
a_FRS(my_data)
}
\references{
Mungroop et al. (2019) \url{doi:10.1097/SLA.0000000000002620}
}
