% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_DFRS.R
\name{io_DFRS}
\alias{io_DFRS}
\title{Calculate Intra-operative Distal Fistula Risk Score (D-FRS)}
\usage{
io_DFRS(my_data)
}
\arguments{
\item{my_data}{A data frame containing the following columns:
\itemize{
\item Texture: Categorical variable ("soft/normal = 1" or "hard/fibrotic = 0")
\item PD_size: Numeric (Pancreatic duct diameter in millimeters)
\item BMI: Numeric (Body mass index in kg/m2)
\item PT: Numeric (Pancreatic thickness in mm)
\item OP_time: Numeric (Operating time in minutes)
}}
}
\value{
A data frame with the Intra-operative (D-FRS) score and risk classification of POPF. Returns NA for cases with missing values.
}
\description{
Calculates the intra-operative Distal Fistula Risk Score (D-FRS) to estimate the probability of clinically relevant (grade B/C) postoperative pancreatic fistula (POPF) according to the 2016 ISGPS definition.
Visit \url{https://www.evidencio.com/models/show/2587#} for more information.
}
\details{
The intra-operative Distal Fistula Risk Score (D-FRS) estimates the probability of clinically relevant (grade B/C) postoperative pancreatic fistula (POPF) as per the 2016 ISGPS definition. It is the initial risk assessment tool specific to POPF following distal pancreatectomy,
enabling tailored treatment and performance comparison across three risk categories.
}
\examples{
my_data <- data.frame(
  ID = 1:4,
  BMI = c(NA, 25, 30, 10),
  PT = c(5, 43, 1, 20),
  PD_size = c(100, 0, 1, 19),
  OP_time = c(NA, 20, 605, NA),
  Texture = c(0, 1, 0, 1)
)
io_DFRS(my_data)

}
\references{
Pastena et al. (2023) \url{doi:10.1097/SLA.0000000000005497}
}
