% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-print.R
\name{print_tree}
\alias{print_tree}
\title{Print a Styled, Formatted Summary of the Decision Tree}
\usage{
print_tree(tree)
}
\arguments{
\item{tree}{The \code{data.tree} object (the root \code{Node}) to be printed.}
}
\value{
The original \code{tree} object (returned invisibly).
}
\description{
Displays a clean, perfectly aligned, color-coded summary of the tree's
current state, based on pre-calculated \code{answer} attributes.
}
\details{
An alternative approach to inspect internal attributes is to use the
\code{data.tree} print() function with named attributes. See the example below.

Available attributes include:
\itemize{
\item rule : AND or OR for a node
\item name : The name of the node or leaf
\item question : The question for leaves
\item answer : The response provided for leaves or the calculated status of nodes
\item confidence : The confidence score provided for leaves (0 - 5) or the
probability that the answer is correct (50\% to 100\%) for nodes
\item true_index : Influence the node has on the overall conclusion,
if the response is TRUE
\item false_index : Influence the node has on the overall conclusion,
if the response is FALSE
\item influence_if_true: Influence the leaf has on the overall conclusion,
if the response is TRUE. This is the product of the ancestor values of
true_index
\item influence_if_false: Influence the leaf has on the overall conclusion,
if the response is FALSE. This is the product of the ancestor values of
false_index
\item influence_index : The sum of influence_if_true and influence_if_false
for each unanswered leaf
}
}
\examples{
# Load a tree
ethical_tree <- load_tree_df(ethical)

# View the tree - initially all 'plain' as no answers
print_tree(ethical_tree)

# Set an answer for leaf 'FIN2' and update the tree
ethical_tree <- set_answer(ethical_tree, "FIN2", TRUE, 3)
ethical_tree <- update_tree(ethical_tree) # Crucial: update the tree to propagate answers
print_tree(ethical_tree)

# Alternative approach to inspect internal attributes using `data.tree::print()
# First, recalculate the internal indices
update_tree(ethical_tree)

# Then print the tree, renaming column headings if required
print(ethical_tree, "rule", "true_index", "false_index", influence = "influence_index")
}
