% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_tree.R
\name{load_tree_csv}
\alias{load_tree_csv}
\title{Load a decision tree from a CSV file (Relational Format)}
\usage{
load_tree_csv(file_path)
}
\arguments{
\item{file_path}{The path to the .csv file.}
}
\value{
A \code{data.tree} object, fully constructed and initialised with \code{answer}
and \code{confidence} attributes set to \code{NA}.
}
\description{
Reads a CSV file from a given path and constructs a tree. This
function expects the CSV to define the tree in a relational
format with \code{id} and \code{parent} columns defining the hierarchy and \code{name},
\code{question} (for leaves) and \code{rule} (for nodes) columns for the decision
tree attributes.
}
\examples{
# Load data from the `ethical.csv` file included with this package
path <- system.file("extdata", "ethical.csv", package = "andorR")
ethical_tree <- load_tree_csv(path)

# View the tree
print_tree(ethical_tree)

}
\seealso{
\code{\link[=load_tree_df]{load_tree_df()}} for the underlying constructor function.
}
