% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{classify}
\alias{classify}
\title{Infer Species for Given Detections}
\usage{
classify(
  model,
  detections,
  resize_width = 480,
  resize_height = 480,
  file_col = "filepath",
  crop = TRUE,
  normalize = TRUE,
  batch_size = 1,
  num_workers = 1,
  device = NULL,
  out_file = NULL
)
}
\arguments{
\item{model}{loaded classifier model}

\item{detections}{manifest of animal detections}

\item{resize_width}{image width input size}

\item{resize_height}{image height input size}

\item{file_col}{column in manifest containing file paths}

\item{crop}{use bbox to crop images before feeding into model}

\item{normalize}{normalize the tensor before inference}

\item{batch_size}{batch size for generator}

\item{num_workers}{number of processes}

\item{device}{send model to the specified device}

\item{out_file}{path to csv to save results to}
}
\value{
detection manifest with added prediction and confidence columns
}
\description{
Infer Species for Given Detections
}
\examples{
\dontrun{animals <- classify(classifier, animals, file_col='filepath')}
}
