% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_adjust-print.R
\name{print.confint_adjust}
\alias{print.confint_adjust}
\title{Print \code{confint_adjust} object}
\usage{
\method{print}{confint_adjust}(x, ...)
}
\arguments{
\item{x}{An \code{confint_adjust} object produced by the
\code{\link[api2lm]{confint_adjust}} function.}

\item{...}{Additional arguments to the
\code{\link[base]{print.data.frame}} function, such as
\code{digits}.}
}
\value{
A \code{data.frame} with columns \code{term},
  \code{lwr}, and \code{upr}, which are the coefficients
  for which inference is being made, and the lower and
  upper bounds of the confidence intervals for each
  coefficient, respectively.
}
\description{
Print an object of class \code{confint_adjust} produced
by the \code{\link[api2lm]{confint_adjust}} function.
}
\examples{
fit <- lm(100/mpg ~ disp + hp + wt + am, data = mtcars)
(cia <- confint_adjust(fit))
print(cia, digits = 3)
}
\author{
Joshua French
}
