% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_slga_soil_profile.R
\name{get_slga_soil_profile}
\alias{get_slga_soil_profile}
\title{Generate a synthetic APSIM soil profile from the SLGA soil database}
\usage{
get_slga_soil_profile(
  lonlat,
  statistic = c("mean", "Q0.5"),
  soil.profile,
  find.location.name = TRUE,
  fix = FALSE,
  verbose = TRUE,
  check = TRUE,
  physical = c("default", "SR"),
  xargs = NULL
)
}
\arguments{
\item{lonlat}{Longitude and latitude vector (e.g. c(151.8306, -27.4969)).}

\item{statistic}{default is the mean}

\item{soil.profile}{a soil profile to fill in in case the default one is not appropriate}

\item{find.location.name}{default is TRUE. Use either maps package or photon API to find Country/State.
If you are running this function many times it might be better to set this to FALSE.}

\item{fix}{whether to fix compatibility between saturation and bulk density (default is FALSE).}

\item{verbose}{argument passed to the fix function.}

\item{check}{whether to check the soil profile (default is TRUE)}

\item{physical}{whether soil physical properties are obtained from the data base or through \sQuote{SR}, Saxton and Rawls pedotransfer functions.}

\item{xargs}{additional arguments passed to \code{\link{apsimx_soil_profile}} or \sQuote{apsimx:::approx_soil_variable} function. At the moment these are:
\sQuote{soil.bottom}, \sQuote{method} and \sQuote{nlayers}.}
}
\value{
it generates an object of class \sQuote{soil_profile}.
}
\description{
Retrieves soil data from the SLGA database (Australia) and converts it to an APSIM soil_profile object
}
\details{
Source: https://esoil.io/TERNLandscapes/Public/Pages/SLGA/index.html
}
\examples{
\dontrun{
## Get soil profile properties for a single point
  sp1 <- get_slga_soil_profile(lonlat = c(151.8306, -27.4969), fix = TRUE, verbose = FALSE)
  ## Visualize
  plot(sp1)
  plot(sp1, property = "water")
}
}
\seealso{
\code{\link{apsimx_soil_profile}}, \code{\link{edit_apsim_replace_soil_profile}}, \code{\link{edit_apsimx_replace_soil_profile}}.
}
\author{
Fernando E. Miguez, Chloe (Yunru Lai), Eric Zurcher (CSIRO) and Andrew Moore (CSIRO)
}
