% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_apsimx.R
\name{sens_apsimx}
\alias{sens_apsimx}
\alias{summary.sens_apsim}
\alias{print.sens_apsim}
\title{Sensitivity Analysis for APSIM Next Generation simulation}
\usage{
sens_apsimx(
  file,
  src.dir = ".",
  parm.paths,
  convert,
  replacement,
  grid,
  soil.profiles = NULL,
  summary = c("mean", "max", "var", "sd", "none"),
  root,
  verbose = TRUE,
  cores = 1L,
  save = FALSE,
  ...
)

\method{summary}{sens_apsim}(
  object,
  ...,
  formula,
  scale = FALSE,
  select = "all",
  warning = TRUE,
  verbose = TRUE
)

\method{print}{sens_apsim}(x, ..., variables = FALSE, summary = FALSE)
}
\arguments{
\item{file}{file name to be run (the extension .apsimx is optional)}

\item{src.dir}{directory containing the .apsimx file to be run (defaults to the current directory)}

\item{parm.paths}{absolute or relative paths of the coefficients to be evaluated.
It is recommended that you use \code{\link{inspect_apsimx}} for this}

\item{convert}{(logical) This argument is needed if there is a need to pass a vector instead of a single value.
The vector can be passed as a character string (separated by spaces) and it will be converted to a
numeric vector. It should be either TRUE or FALSE for each parameter.}

\item{replacement}{TRUE or FALSE for each parameter. Indicating whether it is part of
the \sQuote{replacement} component. Its length should be equal to the length or \sQuote{parm.paths}.}

\item{grid}{grid of parameter values for the evaluation. It can be a data.frame.}

\item{soil.profiles}{list with soil profiles for replacement (see details.)}

\item{summary}{whether to print the full summary of the grid simulations (default is FALSE)}

\item{root}{root argument for \code{\link{edit_apsimx_replacement}}}

\item{verbose}{whether to print to console results of summary}

\item{cores}{number of cores to use for parallel evaluation}

\item{save}{whether to save intermediate results. By default they will be saved as a
\sQuote{csv} file using the name of the apsim file. This will replace \sQuote{apsimx} with \sQuote{csv}.
It is also possible to provide the file name here (for example: \sQuote{Some_results.csv}).}

\item{...}{additional arguments (none used at the moment)}

\item{object}{object of class \sQuote{sens_apsim}}

\item{formula}{formula to be passed to analysis of variance. See \code{\link{formula}}.}

\item{scale}{if all inputs are numeric it is better to scale them. The
default is FALSE as some inputs might be characters or factors. In this
case all inputs will be treated as factors in the sum of squares decomposition.}

\item{select}{option for selecting specific variables in the APSIM output. It will be treated as a regular expression}

\item{warning}{whether to issue a warning when applying this function to an object which has not been summarized}

\item{x}{object of class \sQuote{sens_apsim}}

\item{variables}{whether to print APSIM output variables (default is FALSE)}
}
\value{
object of class \sQuote{sens_apsim}, but really just a list with results from the evaluations.

prints to console if verbose and returns a data frame

compact printing
}
\description{
It is a wrapper for running APSIM-X and evaluating different parameters values

Summary computes variance-based sensitivity indexes from an object of class \sQuote{sens_apsim}

Print method for an object of class \sQuote{sens_apsim}
}
\details{
It is possible to provide a list of soil profiles for replacement in the simulations. In this
case, the parameter path can be simply \sQuote{soil.profile} or \sQuote{soil_profile} if there
is one single simulation. It can also be the path to \sQuote{Soil}. In this case, the path should
be something such as \sQuote{Simulations.SimulationName.Soil}. \sQuote{SimulationName} should
be replaced with the appropriate string.

In the grid, the column with name \sQuote{soil.profile} should contain integers that will be used to
pick from the list of provided soil profiles. In this case it is possible to re-use them.
For example, the values could be 1, 2, 3, etc. to select the corresponding soil profiles from
the \sQuote{soil.profiles} list.

If the \sQuote{cores} argument is greater than 1, then the package \CRANpkg{future} is required.
It will first search for a future plan under options and if nothing is found it will chose an OS-appropriate plan
(\sQuote{multisession}) and it uses the chosen number of cores for execution. Errors, messages and warnings are normally 
suppressed during parallel execution, so it is important to ensure that the simulations are constructed properly.
In testing, cloud services (Box, Dropbox, etc.) do not work well as they seem to interfere with the syncing
of apsim database files. It is suggested that they are turned off when running simulations.

In version 2.8.0 and earlier the original file was changed after it was edited by the function.
In newer versions, the function creates a backup file and then restores it after the code is
executed, if there are no errors.

Suggested reading on the topic of sensitivity analysis:

Pianosa et al (2016). Sensitivity analysis of environmental models: A systematic review with practical workflow.
\doi{10.1016/j.envsoft.2016.02.008}

Saltelli et al. . Global Sensitivity Analysis.
}
\note{
The summary function is stored as an attribute of the data frame \sQuote{grid.sims}.
}
\examples{
\donttest{
## See the vignette for examples
}

}
