% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsim_replace_soil_profile.R
\name{solutes_parms}
\alias{solutes_parms}
\title{Helper function to supply additional Solute parameters}
\usage{
solutes_parms(
  Depth = NA,
  Thickness = NA,
  Solutes = NA,
  InitialValues = NA,
  InitialValuesUnits = NA,
  WaterTableConcentration = NA,
  D0 = NA,
  Exco = NA,
  FIP = NA,
  DepthConstant = NA,
  MaxDepthSoluteAccessible = NA,
  RunoffEffectivenessAtMovingSolute = NA,
  MaxEffectiveRunoff = NA
)
}
\arguments{
\item{Depth}{depth for soil layers (see APSIM documentation)}

\item{Thickness}{soil thickness for layers (either enter Depth or Thickness, but not both). 
Thickness will be recycled if more than one Solute is passed.}

\item{Solutes}{Solutes supplied (for now this can be one or more of: \sQuote{NO3}, \sQuote{NH4} or \sQuote{Urea})}

\item{InitialValues}{initial values of solutes}

\item{InitialValuesUnits}{passed to Solutes}

\item{WaterTableConcentration}{passed to Solutes}

\item{D0}{passed to Solutes}

\item{Exco}{passed to Solutes}

\item{FIP}{passed to Solutes}

\item{DepthConstant}{passed to Solutes}

\item{MaxDepthSoluteAccessible}{passed to Solutes}

\item{RunoffEffectivenessAtMovingSolute}{passed to Solutes}

\item{MaxEffectiveRunoff}{passed to Solutes}
}
\description{
Creates a list with specific components for the Solutes module
}
