% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/munsell2rgb.R
\name{munsell2spc,SoilProfileCollection-method}
\alias{munsell2spc,SoilProfileCollection-method}
\alias{munsell2spc}
\title{Merge Munsell Hue, Value, Chroma converted to sRGB & CIELAB into a SoilProfileCollection}
\usage{
\S4method{munsell2spc}{SoilProfileCollection}(
  object,
  hue = "hue",
  value = "value",
  chroma = "chroma",
  .data = NULL,
  as.spc = TRUE
)
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{hue}{Column name containing numeric hue values. Default: \code{"hue"}}

\item{value}{Column name containing numeric value values. Default: \code{"value"}}

\item{chroma}{Column name containing numeric chroma values. Default: \code{"chroma"}}

\item{.data}{Optional: a character vector of equal length to number of horizons (containing Munsell notation), or a column name in the horizon data OR a data.frame containing three columns (names specified in \code{hue}, \code{value}, \code{chroma})}

\item{as.spc}{Return a data.frame-like object with ID columns?}
}
\value{
A SoilProfileCollection or \code{data.frame}-like object
}
\description{
Convert Munsell hue, value and chroma into sRGB (\code{rgb_R, rgb_G, rgb_B}) and CIELAB (lab_L, lab_A, lab_B) color coordinates using \code{munsell2rgb}. The converted values are stored in the \code{horizons()} slot unless \code{as.spc} is \code{FALSE}, in which case the results are combined with profile and horizon ID columns and returned as the \code{data.frame} subclass used by the SPC.
}
\examples{

data(sp3)
depths(sp3) <- id ~ top + bottom

# inspect input data
horizons(sp3)[,c("hue","value","chroma")]

# do color conversions to sRGB and LAB, join into horizon data
sp3 <- munsell2spc(sp3)

# plot rgb "R" coordinate by horizon
plot(sp3, color = "rgb_R")

# plot lab "A" coordinate by horizon
plot(sp3, color = "lab_A")

# note that `lab_A` values do not exactly match the original `A` values
# this is because `lab_A` was computed from the (field determined) Munsell color notation,
# while `A` was directly measured in the lab by colorimeter
plot(sp3$A, sp3$lab_A, xlab = 'Measured', ylab = 'Converted from Field Observed Munsell')

}
\seealso{
\code{\link{parseMunsell}} \code{\link{rgb2munsell}} \code{\link{munsell2rgb}}
}
