% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind-results.R
\name{rbind_results}
\alias{rbind_results}
\title{Combine multiple data.frames}
\usage{
rbind_results(x, call = rlang::current_env(), .ptype = data.frame())
}
\arguments{
\item{x}{a list where each element is a \code{data.frame} or \code{NULL}.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}

\item{.ptype}{currently unused. Reserved for a future release.}
}
\value{
see details.
}
\description{
A general function that takes a list of \code{data.frame}s and returns a single
and combines them into a single object. It will use the fastest method
available. In order this is \code{\link[collapse:rowbind]{collapse::rowbind()}}, \code{\link[data.table:rbindlist]{data.table::rbindlist()}},
\code{\link[vctrs:vec_chop]{vctrs::list_unchop()}}, then \code{do.call(rbind.data.frame, x)}.
}
\details{
If all items in the list are \code{data.frame}s, then the result will be a \code{data.frame}.
If all elements are an \code{sf} object, then the result will be an \code{sf} object.
If the items are mixed, the result will be a \code{data.frame}.

If any items are \code{NULL}, then an attribute \code{null_elements} will be attached
to the result. The attribute is an integer vector of the indices that
were \code{NULL}.
}
\examples{

x <- head(iris)
res <- rbind_results(list(x, NULL, x))
attr(res, "null_elements")
}
