% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoprocessing-class.R
\name{arc_gp_job}
\alias{arc_gp_job}
\alias{new_gp_job}
\title{Create a Geoprocessing Service Job}
\usage{
new_gp_job(base_url, params = list(), token = arc_token())
}
\arguments{
\item{base_url}{the URL of the job service (without \verb{/submitJob})}

\item{params}{a named list where each element is a scalar character}

\item{token}{default \code{\link[=arc_token]{arc_token()}}. The token to be used with the job.}
}
\value{
An object of class \code{arc_gp_job}.
}
\description{
The \code{arc_gp_job} class is used to interact with Geoprocessing Services in
ArcGIS Online and Enterprise.
}
\details{
The \code{arc_gp_job} uses S7 classes for the job request parameters and job status
via \code{\link[=arc_form_params]{arc_form_params()}} and \code{\link[=arc_job_status]{arc_job_status()}} respectively. Importantly,
\code{\link[=arc_form_params]{arc_form_params()}} ensures that parameters provided to a geoprocessing
service are all character scalars as required by the form body.
}
\examples{
url <- paste0(
  "https://logistics.arcgis.com/arcgis/",
  "rest/services/World/ServiceAreas/",
  "GPServer/GenerateServiceAreas"
)
job <- new_gp_job(url, list(f = "json"))
job

# extract params S7 class
params <- job$params
params

# view underlying list
params@params

}
\seealso{
Other geoprocessing: 
\code{\link{arc_form_params}()},
\code{\link{arc_job_status}()},
\code{\link{gp_params}}
}
\concept{geoprocessing}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{base_url}}{the URL of the job service (without \verb{/submitJob})}

\item{\code{id}}{the ID of the started job. \code{NULL} \code{self$start()} has not been called.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{params}}{returns an S7 object of class \code{arc_form_params} (see \code{\link[=arc_form_params]{arc_form_params()}}) the list can be accessed via \code{self$params@params}.}

\item{\code{status}}{returns the status of the geoprocessing job as an S7 object of class \code{gp_job_status} (see \code{\link[=arc_job_status]{arc_job_status()}}) by querying the \verb{/jobs/\{job-id\}} endpoint.}

\item{\code{results}}{returns the current results of the job by querying the \verb{/jobs/\{job-id\}/results} endpoint.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-arc_gp_job-new}{\code{arc_gp_job$new()}}
\item \href{#method-arc_gp_job-start}{\code{arc_gp_job$start()}}
\item \href{#method-arc_gp_job-cancel}{\code{arc_gp_job$cancel()}}
\item \href{#method-arc_gp_job-await}{\code{arc_gp_job$await()}}
\item \href{#method-arc_gp_job-clone}{\code{arc_gp_job$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-arc_gp_job-new"></a>}}
\if{latex}{\out{\hypertarget{method-arc_gp_job-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{arc_gp_job$new(
  base_url,
  params = list(),
  result_fn = NULL,
  token = arc_token(),
  error_call = rlang::caller_call()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_url}}{the URL of the job service (without \verb{/submitJob})}

\item{\code{params}}{a named list where each element is a scalar character}

\item{\code{result_fn}}{Default \code{NULL}. An optional function to apply to the results JSON. By default parses results using \code{RcppSimdJson::fparse()}.}

\item{\code{token}}{default \code{\link[=arc_token]{arc_token()}}. The token to be used with the job.}

\item{\code{error_call}}{default \code{rlang::caller_call()} the calling environment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-arc_gp_job-start"></a>}}
\if{latex}{\out{\hypertarget{method-arc_gp_job-start}{}}}
\subsection{Method \code{start()}}{
Starts the job by calling the \verb{/submitJob} endpoint. This also sets the public field \code{id}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{arc_gp_job$start()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-arc_gp_job-cancel"></a>}}
\if{latex}{\out{\hypertarget{method-arc_gp_job-cancel}{}}}
\subsection{Method \code{cancel()}}{
Cancels a job by calling the \verb{/cancel} endpoint.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{arc_gp_job$cancel()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-arc_gp_job-await"></a>}}
\if{latex}{\out{\hypertarget{method-arc_gp_job-await}{}}}
\subsection{Method \code{await()}}{
Waits for job completion and returns results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{arc_gp_job$await(interval = 0.1, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interval}}{polling interval in seconds (default 0.1)}

\item{\code{verbose}}{whether to print status messages (default FALSE)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-arc_gp_job-clone"></a>}}
\if{latex}{\out{\hypertarget{method-arc_gp_job-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{arc_gp_job$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
