% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_pbf}
\alias{read_pbf}
\title{Read a FeatureCollection Protocol Buffer}
\usage{
read_pbf(path, post_process = TRUE, use_sf = TRUE)
}
\arguments{
\item{path}{a scalar character of the path to the pbf file}

\item{post_process}{default \code{TRUE}. Apply \code{post_process_pbf()} to the
pbf body.}

\item{use_sf}{default \code{TRUE}. Whether or not to return an \code{sf} object.}
}
\value{
Either a data.frame, list, scalar integer, or sf object if
\code{post_process = TRUE} and \code{use_sf = TRUE}.

See \code{\link[=process_pbf]{process_pbf()}} for more.
}
\description{
Given a binary file containing a FeatureCollection protocol buffer (pbf),
read its contents into R as an R object.
}
\examples{
count_fp <- system.file("count.pbf", package = "arcpbf")
oid_fp <- system.file("ids.pbf", package = "arcpbf")
tbl_fp <- system.file("small-table.pbf", package = "arcpbf")
fc_fp <- system.file("small-points.pbf", package = "arcpbf")

# count response
read_pbf(count_fp)

# object id response
head(read_pbf(oid_fp))

# table feature collection
read_pbf(tbl_fp)

# feature collection with geometry
read_pbf(fc_fp)

}
