% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.r
\name{da_update}
\alias{da_update}
\title{Update Table with arcpy.da}
\usage{
da_update(table.path, d)
}
\arguments{
\item{table.path}{The file path to the table.}

\item{d}{The data to write to \code{table.path}, with the same number
of rows as the table. Column names must match field names
of the table.}
}
\value{
(Invisible) The path to the table, i.e. \code{table.path}.
}
\description{
Update a table (e.g., attribute table of a layer) with the
arcpy.da module.
}
\examples{
\dontrun{
arcpy$env$workspace = tempdir()
arcpy$env$scratchWorkspace = tempdir()
fc = arcpy$management$CopyFeatures(system.file("CA_Counties",
  "CA_Counties_TIGER2016.shp", package = "arcpy"), "CA_Counties")
d = da_read(fc, "ALAND")
d["ALAND"] = d$ALAND+ 5000
da_update(fc, d)
}

}
