% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoe_geometry.R
\name{aoe_geometry}
\alias{aoe_geometry}
\title{Extract AoE Geometries}
\usage{
aoe_geometry(x, which = c("aoe", "original", "both"), support_id = NULL)
}
\arguments{
\item{x}{An \code{aoe_result} object returned by \code{\link[=aoe]{aoe()}}.}

\item{which}{Which geometry to extract: \code{"aoe"} (default), \code{"original"},
or \code{"both"}.}

\item{support_id}{Optional character or numeric vector specifying which
support(s) to extract. If \code{NULL} (default), extracts all.}
}
\value{
An \code{sf} object with polygon geometries and columns:
\describe{
\item{support_id}{Support identifier}
\item{type}{\code{"original"} or \code{"aoe"}}
}
}
\description{
Extract the original support polygons and/or the area of effect polygons
from an \code{aoe_result} object.
}
\examples{
library(sf)

support <- st_as_sf(
  data.frame(region = c("A", "B")),
  geometry = st_sfc(
    st_polygon(list(cbind(c(0, 10, 10, 0, 0), c(0, 0, 10, 10, 0)))),
    st_polygon(list(cbind(c(15, 25, 25, 15, 15), c(0, 0, 10, 10, 0))))
  ),
  crs = 32631
)

pts <- st_as_sf(
  data.frame(id = 1:4),
  geometry = st_sfc(
    st_point(c(5, 5)),
    st_point(c(12, 5)),
    st_point(c(20, 5)),
    st_point(c(27, 5))
  ),
  crs = 32631
)

result <- aoe(pts, support)

# Get AoE polygons
aoe_polys <- aoe_geometry(result, "aoe")

# Get both original and AoE for comparison
both <- aoe_geometry(result, "both")

# Filter to one support (uses row names as support_id)
region_1 <- aoe_geometry(result, "aoe", support_id = "1")

}
