% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regDataseries.R
\name{regDataseries}
\alias{regDataseries}
\title{Register a new dataseries}
\usage{
regDataseries(
  name = NULL,
  description = NULL,
  homepage = NULL,
  version = NULL,
  licence_link = NULL,
  reference = NULL,
  notes = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{name}{\code{\link[=character]{character(1)}}\cr the dataseries abbreviation or
name.}

\item{description}{\code{\link[=character]{character()}}\cr the "long name" or "brief
description" of the dataseries.}

\item{homepage}{\code{\link[=character]{character(1)}}\cr the homepage of the data
provider where the dataseries or additional information can be found.}

\item{version}{\code{\link[=character]{character(1)}}\cr the version number or date when
meta data of the dataseries were recorded.}

\item{licence_link}{\code{\link[=character]{character(1)}}\cr link to the licence or the
webpage from which the licence was copied.}

\item{reference}{\code{\link[=bibentry]{bibentry(1)}}\cr in case the dataseries comes
with a reference, provide this here as bibentry object.}

\item{notes}{\code{\link[=character]{character(1)}}\cr optional notes.}

\item{overwrite}{\code{\link[=logical]{logical(1)}}\cr whether or not the dataseries to
register shall overwrite a potentially already existing older version.}
}
\value{
Returns a tibble of the new entry that is appended to
'inv_dataseries.csv'.
}
\description{
This function registers a new dataseries of both, geometries or areal data
into the geospatial database. This contains the name and relevant meta-data
of a dataseries to enable provenance tracking and reproducability.
}
\examples{
if(dev.interactive()){
  # start the example database
  adb_exampleDB(until = "match_gazetteer", path = tempdir())

  regDataseries(name = "gadm",
                description = "Database of Global Administrative Areas",
                version = "3.6",
                homepage = "https://gadm.org/index.html",
                licence_link = "https://gadm.org/license.html")
}
}
\seealso{
Other register functions: 
\code{\link{regGeometry}()},
\code{\link{regTable}()}
}
\concept{register functions}
