% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_coltypes.R
\name{assert_coltypes}
\alias{assert_coltypes}
\title{Assert that a data.frame's columns are certain types}
\usage{
assert_coltypes(data, coltypes, quiet = FALSE)
}
\arguments{
\item{data}{A data.frame or data.table}

\item{coltypes}{List with names corresponding to columns in \emph{data}. The types of the columns in \emph{data} 
will be tested against types of the elements in coltypes.}

\item{quiet}{Do you want to suppress the printed message when a test is passed? Default = F.}
}
\value{
Throws error if test is violated.
}
\description{
Given a data.frame or data.table object, assert that all columns in the names of the coltypes 
argument match the types of the elements of the coltypes argument.
}
\examples{
# Should pass
assert_coltypes(CO2, list(Plant = integer(), conc = double()))
# Should fail
\dontrun{
  assert_coltypes(CO2, list(Plant = character(), conc = character()))
}
}
