% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_files.R
\name{assert_all_files_exist}
\alias{assert_all_files_exist}
\title{Assert that all files exist}
\usage{
assert_all_files_exist(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{Paths to files (character)}

\item{msg}{A character string containing the error message if any files in \code{x} is does not exist}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if all files in \code{x} exist, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert all files in vector exist. To assert a single file exists, see \code{\link[=assert_file_exists]{assert_file_exists()}}
}
\examples{
real_file <- system.file("DESCRIPTION", package = "assertions")

try({
assert_all_files_exist(c(real_file, real_file))
assert_all_files_exist(c("foo", "bar")) # Throws Error
})

}
\concept{assert_file}
