% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_vector}
\alias{assert_vector}
\title{Assert input is a vector}
\usage{
assert_vector(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not a vector}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a vector, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert input is a vector
}
\note{
By default, lists are not considered vectors (i.e. \code{include_lists = FALSE}) to align with what end-users will expect, in spite of these objects technically being vectors.
}
\examples{
try({
assert_vector(c(1, 2, 3)) # Passes
assert_vector(matrix(1:6, 2, 3)) # Throws default error message
assert_vector(1:3) # Passes

assert_vector(list(1, 2, 3)) # Throws default error message
assert_vector(list(1, 2, 3), include_lists = TRUE) # Passes

assert_vector(c("a", 1, "b"), "Custom error message") # Throws custom error message
assert_vector(factor(c(1, 2, 3)), "Custom error message") # Throws custom error message
})


}
\concept{assert_type}
