% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_nadaraya_watson_quantile.R
\name{f_nadaraya_watson_quantile}
\alias{f_nadaraya_watson_quantile}
\title{Estimation of quantiles using the Nadaraya-Watson estimator with a product kernel}
\usage{
f_nadaraya_watson_quantile(v_dep, v_expl, qt_trgt, bandwidth)
}
\arguments{
\item{v_dep}{Numeric vector of the dependent variable}

\item{v_expl}{Numeric vector or matrix of the (k) explanatory covariate(s)}

\item{qt_trgt}{Numeric vector, dim k, of k quantiles for different qt-estimations}

\item{bandwidth}{Numeric value specifying the bandwidth for the Gaussian kernel}
}
\value{
Numeric matrix with all the predicted values based on each quantile regression, where each column corresponds to a quantile target.
}
\description{
This function performs quantile regression using the Nadaraya-Watson estimator with a product kernel. It computes the weights using a Gaussian kernel for each dimension of the explanatory variables and then estimates the quantile using a weighted average of the observed responses.
}
\examples{
# Data process
set.seed(123)
Y <- as.vector(rnorm(100))
X <- matrix(rnorm(200), ncol = 2)
quantile_target <- c(0.1, 0.5, 0.9)
bandwidth_value <- 0.5

results_qt <- f_nadaraya_watson_quantile(v_dep=Y, 
v_expl=X, 
qt_trgt=quantile_target, 
bandwidth=bandwidth_value)

}
