% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_two_data.R
\name{comparison_two_data}
\alias{comparison_two_data}
\title{Compare the Distribution of the Two Data}
\usage{
comparison_two_data(df1, df2, key_var, y_var)
}
\arguments{
\item{df1}{A data.}

\item{df2}{A data.}

\item{key_var}{A name of index variable name.}

\item{y_var}{A name of target variable.}
}
\value{
No return value, called for side effects
}
\description{
Compare the Distribution of the Two Data
}
\examples{
accepts <- read.csv( system.file( "extdata", "accepts.csv" , package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
d = sort( sample( nrow( feature ), nrow( feature )*0.7))
train <- feature[d,]
test <- feature[-d,]
comparison_two_data( df1 = train , df2 =  test ,
key_var = c("application_id","account_number"), y_var="bad_ind"   )
}
