% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algos.R
\name{my.tbats}
\alias{my.tbats}
\title{Fit TBATS algorithm and make the prediction}
\usage{
my.tbats(prepedTS, n_pred)
}
\arguments{
\item{prepedTS}{A list created by the \code{prepare.ts()} function}

\item{n_pred}{Int number of periods to forecast forward (eg n_pred = 12 will lead to one year of prediction for monthly time series)}
}
\value{
A dataframe with 4 columns : date, average prediction, upper and lower 95% confidence interval bounds
}
\description{
Fit TBATS algorithm and make the prediction
}
\examples{
library(lubridate)
library(dplyr)
dates <- seq(as_date("2000-01-01"),as_date("2010-12-31"),"quarter")
values <- rnorm(length(dates))
my.ts <- prepare.ts(dates,values,"quarter",complete = 0)
my.tbats(my.ts,n_pred=4)

}
