% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{str.am_doc}
\alias{str.am_doc}
\title{Display the structure of an Automerge document}
\usage{
\method{str}{am_doc}(object, max.level = 2, ...)
}
\arguments{
\item{object}{An automerge document object.}

\item{max.level}{Maximum depth to recurse into nested structures. Default 2.}

\item{...}{Additional arguments (ignored).}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
S3 method for \code{\link[utils:str]{utils::str()}} that displays the structure of an Automerge
document in a human-readable format.
}
\examples{
doc <- am_create()
doc$name <- "Alice"
doc$data <- list(x = 1L, y = 2L)
str(doc)
str(doc, max.level = 1)
am_close(doc)

}
