% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlacao.R
\name{teste.correlacao}
\alias{teste.correlacao}
\title{Teste de Correlacao (Pearson ou Spearman)}
\usage{
teste.correlacao(
  x,
  y,
  metodo = "auto",
  ajuda = FALSE,
  verbose = TRUE,
  plot_normalidade = FALSE
)
}
\arguments{
\item{x}{Vetor numerico.}

\item{y}{Vetor numerico.}

\item{metodo}{Metodo de correlacao: "auto" (padrao), "pearson" ou "spearman".}

\item{ajuda}{Se TRUE, exibe explicacao detalhada da funcao.}

\item{verbose}{Se TRUE, imprime mensagens sobre o metodo escolhido e testes de normalidade.}

\item{plot_normalidade}{Se TRUE, gera QQ-plots para avaliacao da normalidade dos dados.}
}
\value{
Objeto de classe \code{htest} com os resultados do teste de correlacao invisivelmente.
}
\description{
Realiza teste de correlacao entre duas variaveis numericas, escolhendo automaticamente
entre o metodo Pearson ou Spearman com base na normalidade dos dados e na presenca de empates.
Opcionalmente exibe graficos de diagnostico e grafico da correlacao com linha de tendencia.
}
\examples{
x <- rnorm(30)
y <- x + rnorm(30)
teste.correlacao(x, y, plot_normalidade = TRUE)

}
