% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$p_value}
\alias{AUTO_VI$p_value}
\title{Compute the p-value based on the check result}
\arguments{
\item{vss}{Numrice. A single numeric value indicating the visual signal
strength for the true residual plot.}

\item{null_dist}{Numeric. A vector of numeric values indicating the visual
signal strength for null residual plots.}
}
\value{
A numeric value representing the desired p-value.
}
\description{
This function computes the p-value of observing the
visual signal strength of the original residual plot based on the null
distribution.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$p_value(
  vss = self$check_result$observed$vss,
  null_dist = self$check_result$null$vss
)
}\if{html}{\out{</div>}}
}
}
\examples{
vss <- 1
null_dist <- rnorm(100, 0, 1)
AUTO_VI$p_value(vss, null_dist)
}
