% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_fleet}
\alias{ec2_create_fleet}
\title{Create Fleet}
\usage{
ec2_create_fleet(
  LaunchTemplateConfigs,
  TargetCapacitySpecification,
  DryRun = NULL,
  ClientToken = NULL,
  SpotOptions = NULL,
  OnDemandOptions = NULL,
  ExcessCapacityTerminationPolicy = NULL,
  TerminateInstancesWithExpiration = NULL,
  Type = NULL,
  ValidFrom = NULL,
  ValidUntil = NULL,
  ReplaceUnhealthyInstances = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{LaunchTemplateConfigs}{List. The configuration for the EC2 Fleet.}

\item{TargetCapacitySpecification}{Object. The number of units to request.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{SpotOptions}{Object. Describes the configuration of Spot Instances in an EC2 Fleet.[optional]}

\item{OnDemandOptions}{Object. Describes the configuration of On-Demand Instances in an EC2 Fleet.[optional]}

\item{ExcessCapacityTerminationPolicy}{Character. Indicates whether running instances should be terminated if the total target capacity of the EC2...[optional]}

\item{TerminateInstancesWithExpiration}{Logical. Indicates whether running instances should be terminated when the EC2 Fleet expires.[optional]}

\item{Type}{Character.   The type of request.[optional]}

\item{ValidFrom}{Character. The start date and time of the request, in UTC format (for example, \emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z)....[optional]}

\item{ValidUntil}{Character. The end date and time of the request, in UTC format (for example, \emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z)....[optional]}

\item{ReplaceUnhealthyInstances}{Logical. Indicates whether EC2 Fleet should replace unhealthy Spot Instances.[optional]}

\item{TagSpecification}{List. The key-value pair for tagging the EC2 Fleet request on creation.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Fleet
}
\section{LaunchTemplateConfigs}{

The
configuration for the EC2 Fleet.
}

\section{TargetCapacitySpecification}{

The number of units
to request.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{

Unique, case-sensitive
identifier that you provide to ensure the idempotency of the request.
For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.
}

\section{SpotOptions}{

Describes
the configuration of Spot Instances in an EC2
Fleet.
}

\section{OnDemandOptions}{

Describes the configuration of On-Demand
Instances in an EC2 Fleet.
}

\section{ExcessCapacityTerminationPolicy}{

Indicates whether running
instances should be terminated if the total target capacity of the EC2
Fleet is decreased below the current size of the EC2
Fleet.
}

\section{TerminateInstancesWithExpiration}{

Indicates whether running instances should be
terminated when the EC2 Fleet expires.
}

\section{Type}{


The type of request. The default value is \code{maintain}.
\itemize{
\item \code{maintain} - The EC2 Fleet places an asynchronous request for your
desired capacity, and continues to maintain your desired Spot
capacity by replenishing interrupted Spot Instances.
\item \code{request} - The EC2 Fleet places an asynchronous one-time request
for your desired capacity, but does submit Spot requests in
alternative capacity pools if Spot capacity is unavailable, and does
not maintain Spot capacity if Spot Instances are interrupted.
\item \code{instant} - The EC2 Fleet places a synchronous one-time request for
your desired capacity, and returns errors for any instances that
could not be launched.
}

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type}{EC2 Fleet request types}
in the \emph{Amazon EC2 User Guide}.
}

\section{ValidFrom}{

The start date and time of the request, in UTC
format (for example, \emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z). The default is
to start fulfilling the request immediately.
}

\section{ValidUntil}{

The end
date and time of the request, in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z). At this point, no new EC2 Fleet
requests are placed or able to fulfill the request. If no value is
specified, the request remains until you cancel
it.
}

\section{ReplaceUnhealthyInstances}{

Indicates whether EC2 Fleet should replace
unhealthy Spot Instances. Supported only for fleets of type \code{maintain}.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks}{EC2 Fleet health checks}
in the \emph{Amazon EC2 User Guide}.
}

\section{TagSpecification}{

The key-value pair
for tagging the EC2 Fleet request on creation. The value for
\code{ResourceType} must be \code{fleet}, otherwise the fleet request fails. To
tag instances at launch, specify the tags in the \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template}{launch template}.
For information about tagging after launch, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources}{Tagging your resources}.
}

