% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encode}
\alias{encode}
\alias{decode}
\alias{decode_as_string}
\alias{encode_file}
\alias{decode_file}
\title{Encode and decode using base64}
\usage{
encode(what, eng = engine())

decode(what, eng = engine())

decode_as_string(what, newline = "\\n", eng = engine())

encode_file(path, eng = engine())

decode_file(path, eng = engine())
}
\arguments{
\item{what}{a character, raw, or blob vector}

\item{eng}{a base64 engine. See \code{\link[=engine]{engine()}} for details.}

\item{newline}{a character sequence to split in the input base64 encoded string on before decoding.}

\item{path}{a path to a base64 encoded file.}
}
\value{
Both \code{encode()} and \code{decode()} are vectorized. They will return a character
and blob vector the same length as \code{what}, respectively.

\code{decode_as_string()} returns a character scalar.
}
\description{
Encode and decode using base64
}
\details{
\subsection{Encoding}{
\itemize{
\item \code{encode()} takes a character vector, list of raw vectors (or blob class), or a raw vector and encodes them into base64 strings.
\item \code{encode_file()} takes a path to a file and encodes it as a base64 string.
}
}

\subsection{Decoding}{
\itemize{
\item \code{decode()} will decode either a base64 encoded character scalar, a raw vector, or a list of raw vectors (see blob package).
\item \code{decode_file()} will decode a base64 encoded file into a raw vector.
\item \code{decode_as_string()} is designed to decode a base64 encoded string to a utf-8 string. By default, it will decode a chunked base64 encoded strings using \verb{\\n} as the separator. Use the \code{newline} argument to determine how to split the input string prior to decoding.
}
}
}
\examples{
# encode hello world
encoded <- encode("Hello world")
encoded

# decode to a blob
decoded <- decode(encoded)
decoded

# convert back to a character
rawToChar(decoded[[1]])
}
