% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.bagged.outlieroutputs.R
\name{print.bagged.outlieroutputs}
\alias{print.bagged.outlieroutputs}
\title{Print outliers in human-readable format}
\usage{
\method{print}{bagged.outlieroutputs}(x, outliers_print = 15, ...)
}
\arguments{
\item{x}{Outliers as returned by predict method on an object from \code{bagged.outliertrees}.}

\item{outliers_print}{Maximum number of outliers to print.}

\item{...}{No use.}
}
\value{
The same input \code{x} that was passed (as \code{invisible}).
}
\description{
Pretty-prints outliers as output by the \code{predict} function from a Bagged OutlierTrees
model (as generated by function \code{bagged.outliertrees}).
}
\examples{
library(bagged.outliertrees)

### example dataset with interesting outliers
data(hypothyroid)

### fit a Bagged OutlierTrees model
model <- bagged.outliertrees(hypothyroid,
  ntrees = 10,
  subsampling_rate = 0.5,
  z_outlier = 6,
  nthreads = 1
)

### use the fitted model to find outliers in the training dataset
outliers <- predict(model,
  newdata = hypothyroid,
  min_outlier_score = 0.5,
  nthreads = 1
)

### print the top-10 outliers in human-readable format
print(outliers, outliers_print = 10)
}
\seealso{
\link{bagged.outliertrees} \link{predict.bagged.outliertrees}
}
