% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_employee.r
\name{get_employee}
\alias{get_employee}
\title{Get employee data by specifying a set of fields.}
\usage{
get_employee(
  id = "directory",
  fields = NULL,
  only_current = FALSE,
  verbose = FALSE,
  api_version = "v1"
)
}
\arguments{
\item{id}{Employee IDs (character or numeric). The default of "directory"
will give a directory of all employees, along with a table of possible fields.
The special employee ID of zero (0) means to use the employee ID associated
with the API key (if any).}

\item{fields}{Character vector of fields to return. To see all available fields,
see the column names of \code{get_employee()}.}

\item{only_current}{Setting to false will return future dated values from
history table fields.}

\item{verbose}{Logical, default FALSE. Whether to return the fields dataframe
when [id = "directory"].}

\item{api_version}{(optional) - Version of API to use to make request. Default is "v1".}
}
\value{
Tibble (dataframe), unless [verbose = TRUE] and [id = "directory"],
 in which case a list with the fields dataframe and the directory dataframe.
}
\description{
This is suitable for getting basic employee information, including current
values for fields that are part of a historical table, like job title,
or compensation information. See the fields endpoint for a list of possible
 fields.
}
\examples{
\dontrun{
get_employee()
get_employee(0, fields = c("firstName", "lastName"))
get_employee(c(0, 1, 2), fields = c("firstName", "lastName", "jobTitle"))
}

}
