% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop_s3.R
\name{\%ne\%.bandicoot_oop}
\alias{\%ne\%.bandicoot_oop}
\title{S3 method of performing the not equals to operator of a
\code{bandicoot_oop} object}
\usage{
\method{\%ne\%}{bandicoot_oop}(x, y)
}
\arguments{
\item{x}{\code{bandicoot_oop} object.}

\item{y}{Object.}
}
\value{
A Boolean value.
}
\description{
This function performs the not equals to operator using the \code{..ne..()} method.
If it is not applicable, error will be raised.
}
\examples{
AGE <- new_class(class_name = "AGE")
age <- AGE$instantiate
register_method(AGE, ..init.. = function(current) self$current = current)
register_method(AGE, ..ne.. = function(y) self$current != y$current)

patrick <- age(33)
james <- age(33)
patrick \%ne\% james

}
