% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDetectorTrace.R
\name{plotDetectorTrace}
\alias{plotDetectorTrace}
\title{Plot BANTER Detector Traces}
\usage{
plotDetectorTrace(x, detector = NULL)
}
\arguments{
\item{x}{a \code{\link{banter_model}} object.}

\item{detector}{names of models to plot. If set to \code{NULL}, traces for 
all models will be shown.}
}
\description{
Plot traces of OOB error rates for detector Random Forest 
  models.
}
\examples{
data(train.data)
# initialize BANTER model with event data
bant.mdl <- initBanterModel(train.data$events)
# add all detector models
bant.mdl <- addBanterDetector(
  bant.mdl, train.data$detectors, 
  ntree = 50, sampsize = 1, num.cores = 1
)

plotDetectorTrace(bant.mdl)

}
\references{
Rankin, S. , Archer, F. , Keating, J. L., Oswald, J. N., 
  Oswald, M. , Curtis, A. and Barlow, J. (2017), Acoustic classification 
  of dolphins in the California Current using whistles, echolocation clicks, 
  and burst pulses. Marine Mammal Science 33:520-540. doi:10.1111/mms.12381
}
\seealso{
\code{\link[rfPermute]{plotTrace}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
