% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrel_prepare.R
\name{barrel_prepare}
\alias{barrel_prepare}
\title{Prepare ordination object for barrel plotting}
\usage{
barrel_prepare(ord, metadata)
}
\arguments{
\item{ord}{A vegan ordination object (e.g., from \code{rda}, \code{cca}, \code{metaMDS}).}

\item{metadata}{A data frame of sample metadata. Must have same number of rows as ordination site scores.}
}
\value{
The ordination object with metadata attached and class \code{"barrel_ord"}.
}
\description{
Attaches sample metadata (e.g., grouping variable) to a vegan ordination object and assigns class 'barrel_ord'.
}
\examples{
library(vegan)
data(dune)
data(dune.env)
ord <- rda(dune, scale = TRUE)
ord_prepared <- barrel_prepare(ord, dune.env)
class(ord_prepared)
}
