% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-chapy.R
\encoding{UTF-8}
\name{model.chapy.apply}
\alias{model.chapy.apply}
\title{Use CHAPY}
\arguments{
\item{tmin, tmean, tmax}{Daily minimum/mean/maximum air temperatures in °C.
For the \code{development} submodel, the parameter that is obligatory depends on
\code{mode}.}

\item{daylength}{Length of the day in hours. Can be created with
\code{\link[=create_daylength_rst]{create_daylength_rst()}} or \code{\link[=create_daylength_rst]{create_daylength_rst()}}.}

\item{mode}{Specifies which temperature should be used to calculate the
development. Can be \code{min}, \code{mean} or \code{max}.}

\item{.submodels, .onset, .diapause, .mortality, ...}{See \code{\link[=phenology]{phenology()}} for a detailled description of the function.}
}
\description{
This page describes the usage of CHAPY with \code{\link[=phenology]{phenology()}}.
The model specific inputs are listed and its basic functionality is explained.
CHAPY was published by \insertCite{Ogris2020;textual}{barrks} and
parametrized for \emph{Pityogenes chalcographus} in Slovenia.
}
\details{
In \code{barrks}, \code{\link[=phenology]{phenology()}} is used to apply a model. The following code
illustrates which inputs are required to apply CHAPY and which additional
parameters are available.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{phenology("chapy", ..., tmin = NULL, tmean = NULL, tmax, daylength, mode = 'max')

# calculate submodels separately
phenology("chapy", ..., .submodels = 'onset', tmax)
phenology("chapy", ..., .submodels = 'diapause', daylength)
phenology("chapy", ..., .submodels = 'mortality', tmax)
phenology("chapy", ..., .submodels = 'development',
          .onset, .diapause = NULL, .mortality = NULL,
          tmin = NULL, tmean = NULL, tmax = NULL, mode = 'max')
}\if{html}{\out{</div>}}
}
\section{Functioning}{


The functioning of CHAPY is identical to \link[=model.rity.apply]{RITY} but it is
has a different \link[=model.chapy.customize]{parametrization}.
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.chapy.customize}}

Other phenology applications: 
\code{\link{model.bso.apply}},
\code{\link{model.joensson.apply}},
\code{\link{model.lange.apply}},
\code{\link{model.phenips.apply}},
\code{\link{model.phenips_clim.apply}},
\code{\link{model.rity.apply}}
}
\concept{phenology applications}
