% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ChainLadder_triangle.R
\name{as_ChainLadder_triangle}
\alias{as_ChainLadder_triangle}
\title{Convert reporting_triangle to ChainLadder triangle format}
\usage{
as_ChainLadder_triangle(x, ...)
}
\arguments{
\item{x}{A \link{reporting_triangle} object to convert.}

\item{...}{Additional arguments passed to \code{\link[ChainLadder:Triangles]{ChainLadder::as.triangle()}}.}
}
\value{
A ChainLadder triangle object (class "triangle" and "matrix"),
with rows representing origin periods (reference dates) and columns
representing development periods (delays).
}
\description{
This function converts a \link{reporting_triangle} object to a triangle object
from the \href{https://CRAN.R-project.org/package=ChainLadder}{ChainLadder}
package.
ChainLadder is a mature package for claims reserving in general insurance
that provides statistical methods for analysing reporting triangles,
including the chain ladder technique, bootstrap methods, and diagnostic
tools.
Converting to ChainLadder format enables use of these specialized methods
alongside baselinenowcast's nowcasting functionality.
}
\details{
This function converts the reporting triangle to ChainLadder's triangle
format using \code{\link[ChainLadder:Triangles]{ChainLadder::as.triangle()}}.
The ChainLadder package must be installed to use this function.

Once converted, you can use any ChainLadder methods such as:
\itemize{
\item \code{\link[ChainLadder:MackChainLadder]{ChainLadder::MackChainLadder()}} for the Mack chain ladder method
\item \code{\link[ChainLadder:BootChainLadder]{ChainLadder::BootChainLadder()}} for bootstrap chain ladder
\item Standard plotting and summary methods
}

Note that some ChainLadder methods may require preprocessing for sparse
triangles with many zeros, which can occur in syndromic surveillance data.

To convert back to a \link{reporting_triangle} object, use
\code{\link[=as_reporting_triangle.triangle]{as_reporting_triangle.triangle()}}.
}
\examples{
\dontshow{if (requireNamespace("ChainLadder", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Create a reporting triangle from synthetic NSSP data
data_as_of_df <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data = data_as_of_df)

# Convert to ChainLadder triangle format
cl_triangle <- as_ChainLadder_triangle(rep_tri)
print(cl_triangle)

# Visualize the reporting triangle structure
plot(cl_triangle)
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=as_reporting_triangle.triangle]{as_reporting_triangle.triangle()}} for converting back
\item \href{https://mages.github.io/ChainLadder/}{ChainLadder package documentation}
}

Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_from_dates}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
