% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes.R
\name{step_basis}
\alias{step_basis}
\title{Recipe step for basis expansions}
\usage{
step_basis(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  fn = NULL,
  options = list(),
  object = NULL,
  prefix = deparse(substitute(fn)),
  skip = FALSE,
  id = recipes::rand_id("basis")
)
}
\arguments{
\item{recipe}{A recipe object.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[recipes:selections]{recipes::selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from the
original variables will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{fn}{The basis function to use, e.g., \code{\link[=b_rff]{b_rff()}}.}

\item{options}{A list of options for the basis function \code{fn}.}

\item{object}{The basis object created once the step has been trained.}

\item{prefix}{The prefix to use for the new column names. Numbers will be
appended, per \code{\link[recipes:names0]{recipes::names0()}}, to create column names.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[recipes:bake]{recipes::bake()}}?}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of recipe with the new step added to the sequence
of any existing operations.
}
\description{
\code{step_basis()} is a single function that creates a \emph{specification} of a recipe
step that will create new columns that are basis expansions, using any of the
basis expansion functions in this package.
}
\section{Tuning Parameters}{
There are no tuning parameters made available to the \code{tunable} interface.
}

\section{Case Weights}{
The underlying operation does not use case weights.
}

\examples{
\dontshow{if (rlang::is_installed("recipes")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rec = recipes::recipe(depth ~ lat + long + mag, quakes)
rec_rff = step_basis(rec, lat, long, fn = b_rff,
                     options = list(p = 5, kernel = k_rbf(2), stdize="none"))
recipes::bake(recipes::prep(rec_rff), new_data=NULL)
\dontshow{\}) # examplesIf}
}
\concept{interfaces}
