% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdpnormal.R
\name{bdpnormal}
\alias{bdpnormal}
\alias{bdpnormal-method}
\alias{bdpnormal,ANY-method}
\title{Bayesian Discount Prior: Gaussian mean values}
\usage{
bdpnormal(
  mu_t = NULL,
  sigma_t = NULL,
  N_t = NULL,
  mu0_t = NULL,
  sigma0_t = NULL,
  N0_t = NULL,
  mu_c = NULL,
  sigma_c = NULL,
  N_c = NULL,
  mu0_c = NULL,
  sigma0_c = NULL,
  N0_c = NULL,
  discount_function = "identity",
  alpha_max = 1,
  fix_alpha = FALSE,
  weibull_scale = 0.135,
  weibull_shape = 3,
  number_mcmc = 10000,
  method = "mc",
  compare = TRUE
)
}
\arguments{
\item{mu_t}{scalar. Mean of the current treatment group.}

\item{sigma_t}{scalar. Standard deviation of the current treatment group.}

\item{N_t}{scalar. Number of observations of the current treatment group.}

\item{mu0_t}{scalar. Mean of the historical treatment group.}

\item{sigma0_t}{scalar. Standard deviation of the historical treatment group.}

\item{N0_t}{scalar. Number of observations of the historical treatment group.}

\item{mu_c}{scalar. Mean of the current control group.}

\item{sigma_c}{scalar. Standard deviation of the current control group.}

\item{N_c}{scalar. Number of observations of the current control group.}

\item{mu0_c}{scalar. Mean of the historical control group.}

\item{sigma0_c}{scalar. Standard deviation of the historical control group.}

\item{N0_c}{scalar. Number of observations of the historical control group.}

\item{discount_function}{character. Specify the discount function to use.
Currently supports \code{weibull}, \code{scaledweibull}, and
\code{identity}. The discount function \code{scaledweibull} scales the
output of the Weibull CDF to have a max value of 1. The \code{identity}
discount function uses the posterior probability directly as the discount
weight. Default value is "\code{identity}".}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{fix_alpha}{logical. Fix alpha at alpha_max? Default value is FALSE.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. For a two-arm trial, users may specify a vector of two
values where the first value is used to estimate the weight of the
historical treatment group and the second value is used to estimate the
weight of the historical control group. Not used when
\code{discount_function} = "identity".}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group. Not used when \code{discount_function} =
"identity".}

\item{number_mcmc}{scalar. Number of Monte Carlo simulations. Default is
10000.}

\item{method}{character. Analysis method with respect to estimation of the
weight parameter alpha. Default method "\code{mc}" estimates alpha for each
Monte Carlo iteration. Alternate value "\code{fixed}" estimates alpha once
and holds it fixed throughout the analysis.  See the the \code{bdpnormal}
vignette \cr \code{vignette("bdpnormal-vignette", package="bayesDP")} for
more details.}

\item{compare}{logical. Should a comparison object be included in the fit?
For a one-arm analysis, the comparison object is simply the posterior chain
of the treatment group parameter. For a two-arm analysis, the comparison
object is the posterior chain of the treatment effect that compares
treatment and control. If \code{compare=TRUE}, the comparison object is
accessible in the \code{final} slot, else the \code{final} slot is
\code{NULL}. Default is \code{TRUE}.}
}
\value{
\code{bdpnormal} returns an object of class "bdpnormal". The
  functions \code{\link[=summary,bdpnormal-method]{summary}} and
  \code{\link[=print,bdpnormal-method]{print}} are used to obtain and print a
  summary of the results, including user inputs. The
  \code{\link[=plot,bdpnormal-method]{plot}} function displays visual outputs
  as well.

An object of class \code{bdpnormal} is a list containing at least
the following components:
\describe{
 \item{\code{posterior_treatment}}{
   list. Entries contain values related to the treatment group:
   \itemize{
     \item \code{alpha_discount}
       numeric. Alpha value, the weighting parameter of the historical data.
     \item \code{p_hat}
       numeric. The posterior probability of the stochastic comparison
       between the current and historical data.
     \item \code{posterior_mu}
       vector. A vector of length \code{number_mcmc} containing the posterior
       mean of the treatment group. If historical treatment data is present,
       the posterior incorporates the weighted historical data.
     \item \code{posterior_sigma2}
       vector. A vector of length \code{number_mcmc} containing the posterior
       variance of the treatment group. If historical treatment data is present,
       the posterior incorporates the weighted historical data.
     \item \code{posterior_flat_mu}
       vector. A vector of length \code{number_mcmc} containing
       Monte Carlo samples of the mean of the current treatment group
       under a flat/non-informative prior, i.e., no incorporation of the
       historical data.
     \item \code{posterior_flat_sigma2}
       vector. A vector of length \code{number_mcmc} containing
       Monte Carlo samples of the standard deviation of the current treatment group
       under a flat/non-informative prior, i.e., no incorporation of the
       historical data.
     \item \code{prior_mu}
       vector. If historical treatment data is present, a vector of length
       \code{number_mcmc} containing Monte Carlo samples of the mean
       of the historical treatment group under a flat/non-informative prior.
     \item\code{prior_sigma2}
       vector. If historical treatment data is present, a vector of length
       \code{number_mcmc} containing Monte Carlo samples of the standard deviation
       of the historical treatment group under a flat/non-informative prior.
   }
 }
 \item{\code{posterior_control}}{
   list. Similar entries as \code{posterior_treament}. Only present if a
   control group is specified.
 }
 \item{\code{final}}{
   list. Contains the final comparison object, dependent on the analysis type:
   \itemize{
     \item One-arm analysis:
       vector. Posterior chain of the mean.
     \item Two-arm analysis:
       vector. Posterior chain of the mean difference comparing treatment and
       control groups.
   }
 }
 \item{\code{args1}}{
   list. Entries contain user inputs. In addition, the following elements
   are output:
   \itemize{
     \item \code{arm2}
       binary indicator. Used internally to indicate one-arm or two-arm
       analysis.
     \item \code{intent}
       character. Denotes current/historical status of treatment and
       control groups.
   }
 }
}
}
\description{
\code{bdpnormal} is used for estimating posterior samples from a
  Gaussian outcome where an informative prior is used. The prior weight is
  determined using a discount function. This code is modeled after the
  methodologies developed in Haddad et al. (2017).
}
\details{
\code{bdpnormal} uses a two-stage approach for determining the
  strength of historical data in estimation of a mean outcome. In the first
  stage, a \emph{discount function} is used that that defines the maximum
  strength of the historical data and discounts based on disagreement with
  the current data. Disagreement between current and historical data is
  determined by stochastically comparing the respective posterior
  distributions under noninformative priors. With Gaussian data, the
  comparison is the proability (\code{p}) that the current mean is less than
  the historical mean. The comparison metric \code{p} is then input into the
  discount function and the final strength of the historical data is returned
  (alpha).

  In the second stage, posterior estimation is performed where the discount
  function parameter, \code{alpha}, is used incorporated in all posterior
  estimation procedures.

  To carry out a single arm (OPC) analysis, data for the current treatment
  (\code{mu_t}, \code{sigma_t}, and \code{N_t}) and historical treatment
  (\code{mu0_t}, \code{sigma0_t}, and \code{N0_t}) must be input. The results
  are then based on the posterior distribution of the current data augmented
  by the historical data.

  To carry our a two-arm (RCT) analysis, data for the current treatment and
  at least one of current or historical control data must be input. The
  results are then based on the posterior distribution of the difference
  between current treatment and control, augmented by available historical
  data.

  For more details, see the \code{bdpnormal} vignette: \cr
  \code{vignette("bdpnormal-vignette", package="bayesDP")}
}
\examples{
# One-arm trial (OPC) example
fit <- bdpnormal(
  mu_t = 30, sigma_t = 10, N_t = 50,
  mu0_t = 32, sigma0_t = 10, N0_t = 50,
  method = "fixed"
)
summary(fit)
\dontrun{
plot(fit)
}

# Two-arm (RCT) example
fit2 <- bdpnormal(
  mu_t = 30, sigma_t = 10, N_t = 50,
  mu0_t = 32, sigma0_t = 10, N0_t = 50,
  mu_c = 25, sigma_c = 10, N_c = 50,
  mu0_c = 25, sigma0_c = 10, N0_c = 50,
  method = "fixed"
)
summary(fit2)
\dontrun{
plot(fit2)
}

}
\references{
Haddad, T., Himes, A., Thompson, L., Irony, T., Nair, R. MDIC Computer
  Modeling and Simulation working group.(2017) Incorporation of stochastic
  engineering models as prior information in Bayesian medical device trials.
  \emph{Journal of Biopharmaceutical Statistics}, 1-15.
}
\seealso{
\code{\link[=summary,bdpnormal-method]{summary}},
  \code{\link[=print,bdpnormal-method]{print}},
  and \code{\link[=plot,bdpnormal-method]{plot}} for details of each of the
  supported methods.
}
