% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_plot.R
\name{bayes_plot_hist}
\alias{bayes_plot_hist}
\title{Plot histogram}
\usage{
bayes_plot_hist(x, scale = 1, quantile = NULL, sample_size = 15000)
}
\arguments{
\item{x}{SpatRaster to be plotted.}

\item{scale}{Scale factor for SpatRaster}

\item{quantile}{Threshold of values that will be plotted}

\item{sample_size}{Number of samples to extract values}
}
\value{
A plot object
}
\description{
Plot histogram
}
\examples{
if (bayes_run_examples()) {
    # get the probability file
    data_dir <- system.file("/extdata/probs/", package = "bayesEO")
    file <- list.files(data_dir)
    # read the probability file into a SpatRaster
    x <- terra::rast(paste0(data_dir, "/", file))
    # include the labels
    labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
             "ClearCut_Veg", "Forest", "Wetland")
    # associate the labels to the names of the SpatRaster
    names(x) <- labels
    # calculate the variance
    v <- bayes_variance(x)
    # Plot the variance histogram
    bayes_hist(v, quantile = 0.75)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
