% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_plot.R
\name{bayes_plot_rgb}
\alias{bayes_plot_rgb}
\title{Plot RGB data cubes}
\usage{
bayes_plot_rgb(
  image,
  red,
  green,
  blue,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL
)
}
\arguments{
\item{image}{Object of class SpatRaster.}

\item{red}{Band for red color.}

\item{green}{Band for green color.}

\item{blue}{Band for blue color.}

\item{xmin}{Subset to be shown (xmin)}

\item{xmax}{Subset to be shown (xmax)}

\item{ymin}{Subset to be shown (ymin)}

\item{ymax}{Subset to be shown (ymax)}
}
\value{
A plot object with an RGB image
}
\description{
Plot RGB raster cube
}
\examples{
if (bayes_run_examples()) {
# Define location of a RGB files
rgb_dir <- system.file("/extdata/rgb", package = "bayesEO")
# list the file
files <- list.files(rgb_dir)
# build the full path
image_files <- paste0(rgb_dir, "/", files)
rgb_image <- bayes_read_image(image_files)
bayes_plot_rgb(rgb_image, red = "B11", green = "B8A", blue = "B03")
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
