% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMF.R
\name{PMF.get_quantile}
\alias{PMF.get_quantile}
\title{Get quantile from a PMF object}
\usage{
PMF.get_quantile(pmf, p)
}
\arguments{
\item{pmf}{the PMF object.}

\item{p}{the probability of the required quantile.}
}
\value{
A numeric value for the quantile.
}
\description{
Returns the \code{p} quantile from the PMF specified by \code{pmf}.
}
\examples{
library(bayesRecon)

# Let's build the pmf of a Binomial distribution with parameters n and p
n <- 10
p <- 0.6 
pmf_binomial <- apply(matrix(seq(0,10)),MARGIN=1,FUN=function(x) dbinom(x,size=n,prob=p))

# The true median is ceiling(n*p)
quant_50 <- PMF.get_quantile(pmf=pmf_binomial,p=0.5)
cat("True median:", ceiling(n*p), "\nMedian from PMF:", quant_50)


}
\seealso{
\code{\link[=PMF.get_mean]{PMF.get_mean()}}, \code{\link[=PMF.get_var]{PMF.get_var()}}, \code{\link[=PMF.sample]{PMF.sample()}}, \code{\link[=PMF.summary]{PMF.summary()}}
}
