% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeTime.R
\name{nearestTimeandID}
\alias{nearestTimeandID}
\title{Merge data frames based on the nearest datetime differences and an ID column. Also removes duplicate column names from the result.}
\usage{
nearestTimeandID(df1, df2, timeCol1, timeCol2, IDcol)
}
\arguments{
\item{df1}{Data frame containing the dates for which the differences between the other data frame's date column should be minimized for each row.}

\item{df2}{Data frame containing the dates which should be compared to, as well as other values that should be merged to df1 per minimized date time.}

\item{timeCol1}{Character vector specifying the date/time column in df1.}

\item{timeCol2}{Character vector specifying the date/time column in df2.}

\item{IDcol}{Must be unique by row in df1. Multiple versions are allowed (and expected at least in some rows, as that is the point of the function) in df2.}
}
\value{
A merged data frame that minimizes datetime differences.
}
\description{
Takes two data frames each with time/date columns in date-time or date format (i.e., able to be compared using the function difftime), finds the rows of df2 that minimize the absolute value of the datetime for each of the rows in df1, and merges the corresponding rows of df2 into df1 for downstream processing.
}

