% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesGA.R
\name{BayesGA}
\alias{BayesGA}
\title{Estimating the Student's t degrees of freedom (dof) with a Gamma Prior over the dof}
\usage{
BayesGA(y, ini.nu = 1, S = 1000, delta = 0.001, a = 1, b = 0.1)
}
\arguments{
\item{y}{an N-dimensional vector of continuous observations supported on the real-line}

\item{ini.nu}{the initial posterior sample value of the degrees of freedom (default is 1)}

\item{S}{the number of posterior samples (default is 1000)}

\item{delta}{the step size for the respective sampling engines (default is 0.001)}

\item{a}{rate parameter of Gamma prior (default is 1, corresponds to an Exponential prior)}

\item{b}{rate parameter of Gamma prior (default is 0.1)}
}
\value{
A vector of posterior sample estimates
\item{res}{an S-dimensional vector with the posterior samples}
}
\description{
\code{BayesGA} samples from the posterior distribution of the degrees of freedom (dof) with Gamma prior endowed upon the dof, using a random walk Metropolis (RMW) algorithm.
}
\examples{

# data from Student's t-distribution with dof = 0.1
y = rt(n = 100, df = 0.1)

# running the random walk Metropolis algorithm with default settings
nu = BayesGA(y)
# reporting the posterior mean estimate of the dof
mean(nu)

# application to log-return (daily index values) of United States (S&P500)
data(index_return)
# log-returns of United States
index_return_US <- dplyr::filter(index_return, Country == "United States")
y = index_return_US$log_return_rate

# running the random walk Metropolis algorithm with default settings
nu = BayesGA(y)
# reporting the posterior mean estimate of the dof from the log-return data of US
mean(nu)

}
\references{
Lee, S. Y. (2022). "The Use of a Log-Normal Prior for the Student t-Distribution",
\emph{Axioms}, \doi{doi:10.3390/axioms11090462}

Fernández, C., Steel, M. F. (1998). "On Bayesian modeling of fat tails and skewness",
\emph{Journal of the American Statistical Association}, \doi{10.1080/01621459.1998.10474117}

Juárez, M. A., Steel, M. F. (2010). "Model-Based Clustering of Non-Gaussian Panel Data Based on Skew-t Distributions",
\emph{Journal of Business and Economic Statistics}, \doi{10.1198/jbes.2009.07145}
}
