% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.aov_b.R
\name{predict.aov_b}
\alias{predict.aov_b}
\title{Predict method for aov_b model fits}
\usage{
\method{predict}{aov_b}(object, CI_level = 0.95, PI_level = 0.95, ...)
}
\arguments{
\item{object}{Object of class aov_b}

\item{CI_level}{Posterior probability covered by credible interval}

\item{PI_level}{Posterior probability covered by prediction interval}

\item{...}{optional arguments.}
}
\value{
tibble with estimate (posterior mean), prediction intervals, and credible intervals
for the mean.
}
\description{
Predict method for aov_b model fits
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data = 
  data.frame(x1 = rep(letters[1:5],N/5))
test_data$outcome = 
  rnorm(N,-1 + 2 * (test_data$x1 \%in\% c("d","e")) )

# Fit 1-way ANOVA model
fit1 <-
  aov_b(outcome ~ x1,
        test_data,
        prior_mean_mu = 2,
        prior_mean_nu = 0.5,
        prior_var_shape = 0.01,
        prior_var_rate = 0.01)
predict(fit1)
}



}
