% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesmsm.R
\name{bayesmsm}
\alias{bayesmsm}
\title{Bayesian Marginal Structural Model Bootstrap Estimation}
\usage{
bayesmsm(
  ymodel,
  nvisit,
  reference = c(rep(0, nvisit)),
  comparator = c(rep(1, nvisit)),
  treatment_effect_type = "sq",
  family = "gaussian",
  data,
  wmean = rep(1, nrow(data)),
  nboot = 1000,
  optim_method = "BFGS",
  seed = NULL,
  parallel = TRUE,
  ncore = 4
)
}
\arguments{
\item{ymodel}{Model statement for the outcome variable.}

\item{nvisit}{Number of visits or time points to simulate.}

\item{reference}{Vector denoting the intervention to be used as the reference across all visits for calculating the risk ratio and risk difference. The default is a vector of all 0's with length nvisit (i.e. never treated).}

\item{comparator}{Vector denoting the intervention to be used as the comparator across all visits for calculating the risk ratio and risk difference. The default is a vector of all 1's with length nvisit (i.e. always treated).}

\item{treatment_effect_type}{Character string specifying the type of treatment effect to estimate. Options are "sq" for sequential treatment effects, which estimates effects for specific treatment sequences across visits, and "cum" for cumulative treatment effects, which assumes a single cumulative treatment variable representing the total exposure. The default is "sq".}

\item{family}{Character string specifying the outcome distribution family. The possible distributions are: "Gaussian" (default) for continuous outcomes, and "binomial" for binary outcomes.}

\item{data}{Data table containing the variable names in the outcome model.}

\item{wmean}{Vector of treatment assignment weights. The default is rep(1, nrow(data)).}

\item{nboot}{Integer specifying the number of bootstrap iterations. The default is 1000.}

\item{optim_method}{Character string specifying the optimization method to be used. The default is "BFGS".}

\item{seed}{Starting seed for simulations and bootstrapping. The default is NULL.}

\item{parallel}{Logical scalar indicating whether to parallelize bootstrapping to multiple cores. The default is TRUE.}

\item{ncore}{Integer specifying the number of CPU cores to use in parallel simulation. This argument is required when parallel is set to TRUE, and the default is 4.}
}
\value{
It returns an object of class "bayesmsm" that contains the information about the data, model, etc.
An object of class "bayesmsm" is a list containing at least the following components: "mean", the mean of the bootstrap estimates; "sd", the standard deviation of the bootstrap estimates; "quantile", the 95\% quantiles of the bootstrap estimates; "bootdata", a data frame of bootstrapped estimates; "reference", the reference intervention level and "comparator", the comparison intervention level
}
\description{
This function performs Bayesian non-parametric bootstrap to estimate causal
effects in Bayesian marginal structural models. It supports both continuous
(Gaussian) and binary (binomial) outcome variables
}
\examples{
# 1) Specify simple treatment‐assignment models
amodel <- list(
  c("(Intercept)" =  0, "L1_1" =  0.5, "L2_1" = -0.5),
  c("(Intercept)" =  0, "L1_2" =  0.5, "L2_2" = -0.5, "A_prev" = 0.3)
)
# 2) Specify a continuous‐outcome model
ymodel <- c("(Intercept)" = 0,
            "A1"         = 0.2,
            "A2"         = 0.3,
            "L1_2"       = 0.1,
            "L2_2"       = -0.1)
# 3) Simulate without right‐censoring
testdata <- simData(
  n                = 200,
  n_visits         = 2,
  covariate_counts = c(2, 2),
  amodel           = amodel,
  ymodel           = ymodel,
  y_type           = "continuous",
  right_censor     = FALSE,
  seed             = 123)
model <- bayesmsm(ymodel = Y ~ A1 + A2,
                  nvisit = 2,
                  reference = c(rep(0,2)),
                  comparator = c(rep(1,2)),
                  treatment_effect_type = "sq",
                  family = "binomial",
                  data = testdata,
                  wmean = rep(1,200),
                  nboot = 10,
                  optim_method = "BFGS",
                  seed = 890123,
                  parallel = FALSE)
}
