% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fx-rates.R
\name{boc_fx_rates}
\alias{boc_fx_rates}
\title{Fetch Bank of Canada foreign exchange rates}
\source{
\url{https://www.cbsa-asfc.gc.ca/eservices/api/er-tc-api-eng.html}
}
\usage{
boc_fx_rates(start_date = NULL, end_date = NULL, limit = NULL, skip = NULL)
}
\arguments{
\item{start_date}{(\code{NULL} | \code{Date(1)} | \code{character(1)})\cr
Start date of the data. Default \code{NULL}.}

\item{end_date}{(\code{NULL} | \code{Date(1)} | \code{character(1)})\cr
End date of the data. Default \code{NULL}.}

\item{limit}{(\code{NULL} | \code{integer(1)})\cr
Maximum number of records to return. Default \code{NULL} (all records).}

\item{skip}{(\code{NULL} | \code{integer(1)})\cr
Number of records to skip. Default \code{NULL} (do not skip any records).}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the exchange rates.
}
\description{
Fetch the latest or historical foreign exchange reference rates from the Bank of Canada (BoC).
}
\details{
The recorded rates indicate the number of Canadian dollars required to buy a single unit of the
foreign currency. New rates are released by the Bank of Canada (BoC) daily at 4:30 pm. The Canada
Border Services (CBSA) retrieves these updates between 4:30 pm and 5 pm ET.

BoC provides 23 foreign exchange rates. All other rates are maintained by the CBSA.

Exchange rates from the BoC are updated daily in the system while other exchange rates are
updated by the CBSA at set intervals. The updated rates are available for retrieval between 7 pm
and 11:59 pm ET.

As BoC publishes exchange rates every business day, it is recommended that exchange rate data be
retrieved on a daily basis. This retrieval should occur after 7 pm ET to ensure retrieval of the
latest updates.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
# fetch latest exchange rates
boc_fx_rates()

# fetch historical exchange rates
boc_fx_rates(start_date = "2021-10-22", end_date = "2021-10-23", limit = 10, skip = 2)
}
\dontshow{\}) # examplesIf}
}
