% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcuts.R
\name{nr_districts}
\alias{nr_districts}
\title{British Columbia Natural Resource (NR) Districts}
\source{
\code{bcdata::bcdc_get_data(record = '0bc73892-e41f-41d0-8d8e-828c16139337', resource = 'e6676e55-2a6f-4b2b-91ad-3caf291ac5d4')}
}
\usage{
nr_districts(ask = interactive(), force = FALSE)
}
\arguments{
\item{ask}{Should the function ask the user before downloading the data to a cache? Defaults to the value of interactive().}

\item{force}{Should you force download the data?}
}
\value{
The spatial layer of \code{nr_districts} as an \code{sf} object.
}
\description{
British Columbia Natural Resource (NR) Districts
}
\examples{
\dontrun{
my_layer <- nr_districts()
}

}
\seealso{
Other BC layers: 
\code{\link{airzones}()},
\code{\link{bc_bound}()},
\code{\link{bc_bound_hres}()},
\code{\link{bc_cities}()},
\code{\link{bec}()},
\code{\link{census_dissemination_area}()},
\code{\link{census_division}()},
\code{\link{census_economic}()},
\code{\link{census_metropolitan_area}()},
\code{\link{census_subdivision}()},
\code{\link{census_tract}()},
\code{\link{ecoprovinces}()},
\code{\link{ecoregions}()},
\code{\link{ecosections}()},
\code{\link{fsa}()},
\code{\link{gw_aquifers}()},
\code{\link{health_chsa}()},
\code{\link{health_ha}()},
\code{\link{health_hsda}()},
\code{\link{health_lha}()},
\code{\link{hydrozones}()},
\code{\link{mapsheets_250K}()},
\code{\link{mapsheets_50K}()},
\code{\link{municipalities}()},
\code{\link{nr_areas}()},
\code{\link{nr_regions}()},
\code{\link{regional_districts}()},
\code{\link{tsa}()},
\code{\link{water_districts}()},
\code{\link{water_precincts}()},
\code{\link{watercourses_15M}()},
\code{\link{watercourses_5M}()},
\code{\link{wsc_drainages}()}
}
\concept{BC layers}
