% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bct.R
\name{bct}
\alias{bct}
\title{Applying the Box-Cox Transformation.}
\usage{
bct(y, lambda)
}
\arguments{
\item{y}{a positive real number vector.}

\item{lambda}{a scalar transformation parameter.}
}
\value{
bct returns the Box-Cox transformed numeric vector,
\code{z = log(y)} for \code{lambda = 0},
\code{z = (y ^ lambda - 1) / lambda} for \code{lambda ne 1}.
}
\description{
\code{bct} returns the Box-Cox transformed numeric vector (Box and Cox,
1964).
}
\examples{
  y <- exp(rnorm(10))
  z <- bct(y, 0) #log transformation

}
\references{
Box, G.E.P. and Cox, D.R. (1964). An analysis of transformations
(with discussion).
\emph{Journals of the Royal Statistical Society, Series B}, 26,
211-246, \doi{10.1111/j.2517-6161.1964.tb00553.x}.
}
