% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdlim-package.R
\docType{package}
\name{bdlim-package}
\alias{bdlim}
\alias{bdlim-package}
\title{bdlim: Bayesian Distributed Lag Interaction Models}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Estimation and interpretation of Bayesian distributed lag interaction models (BDLIMs). A BDLIM regresses a scalar outcome on repeated measures of exposure and allows for modification by a categorical variable under four specific patterns of modification. The main function is bdlim(). There are also summary and plotting files. Details on methodology are described in Wilson et al. (2017) \doi{10.1093/biostatistics/kxx002}.
}
\details{
The main function is \code{\link{bdlim4}}.
}
\references{
Wilson A, Chiu YM, Hsu HL, Wright RO, Wright RJ, Coull BA (2017).
“Bayesian distributed lag interaction models to identify perinatal windows
of vulnerability in children's health.”
\emph{Biostatistics}, 18(3), 537–552.
\doi{https://doi.org/10.1093/biostatistics/kxx002}.
\href{https://arxiv.org/abs/1612.05800}{arXiv preprint}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://anderwilson.github.io/bdlim/}
  \item \url{https://github.com/AnderWilson/bdlim/}
  \item Report bugs at \url{https://github.com/anderwilson/bdlim/issues/}
}

}
\author{
\strong{Maintainer}: Ander Wilson \email{ander.wilson@colostate.edu} (\href{https://orcid.org/0000-0003-4774-3883}{ORCID})

}
\keyword{internal}
