% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyte_mfi.R
\name{geometric_mean}
\alias{geometric_mean}
\title{Calculate geometric mean}
\usage{
geometric_mean(.x)
}
\arguments{
\item{.x}{A numeric to take the geometric mean of}
}
\value{
A single numeric value
}
\description{
Calculate geometric mean
}
\section{Mean calculation}{

The geometric mean is given by:

\deqn{
  \left(\prod_{i=1}^n x_i \right)^\frac{1}{n}
}{prod(x)^(length(x))}

but implemented as:

\deqn{
  \frac{1}{n}\exp{\sum_{i=1}^n\log(x_i)}
}{exp(sum(log(x[x > 0])) / length(x))}

\code{NA}s are removed before calculation
}

\examples{
beadplexr:::geometric_mean(runif(10))

}
\keyword{internal}
